<?php

declare(strict_types=1);

if (!defined('ABSPATH')) {
	exit;
}

spl_autoload_register(static function (string $class): void {
	$prefix = 'ContentReady\\';
	if (strpos($class, $prefix) !== 0) {
		return;
	}

	$relative = substr($class, strlen($prefix));
	$path = CR_PLUGIN_DIR . 'includes/' . str_replace('\\', '/', $relative) . '.php';
	if (is_file($path)) {
		require_once $path;
	}
});

