<?php

declare(strict_types=1);

namespace ContentReady\SiteEntrances;

final class UrlList
{
	/**
	 * @return array<int, array{url:string,label:string}>
	 */
	public static function parse_recommended(string $raw): array
	{
		$raw = str_replace(["\r\n", "\r"], "\n", $raw);
		$lines = explode("\n", $raw);

		$out = [];
		foreach ($lines as $line) {
			if (count($out) >= 200) {
				break;
			}

			$line = trim((string)$line);
			if ($line === '') {
				continue;
			}

			// 允许写说明/注释（不参与解析）
			if ($line[0] === '#' || $line[0] === '>') {
				continue;
			}

			// 允许用 Markdown 列表写法粘贴（- / * / +）
			$line = preg_replace('/^\\s*[-*+]\\s+/', '', $line);
			$line = trim((string)$line);
			if ($line === '') {
				continue;
			}

			$url = '';
			$label = '';

			if (strpos($line, '|') !== false) {
				$parts = explode('|', $line, 2);
				$url = trim((string)($parts[0] ?? ''));
				$label = trim((string)($parts[1] ?? ''));
			} else {
				$parts = preg_split('/\\s+/', $line, 2);
				$url = trim((string)($parts[0] ?? ''));
				$label = trim((string)($parts[1] ?? ''));
			}

			if ($url === '') {
				continue;
			}

			if (strpos($url, '://') === false && strpos($url, '/') === 0) {
				$url = home_url($url);
			}

			$url = (string)esc_url_raw($url);
			if ($url === '' || preg_match('~^https?://~i', $url) !== 1) {
				continue;
			}

			if ($label === '') {
				$label = $url;
			}

			$label = sanitize_text_field($label);
			if ($label === '') {
				$label = $url;
			}

			$out[] = [
				'url' => $url,
				'label' => $label,
			];
		}

		return $out;
	}
}

