<?php

declare(strict_types=1);

namespace ContentReady\Rest\Post\Modules;

use ContentReady\Admin\Settings;
use ContentReady\Generator\V1Generator;
use ContentReady\Licensing\Capabilities;
use ContentReady\Meta\MetaStore;
use ContentReady\Modules\Config as ModulesConfig;
use ContentReady\Modules\Registry;
use ContentReady\Modules\Sanitizer;
use ContentReady\Rest\Post\Meta;

final class UpdateModule
{
	public static function handle(\WP_REST_Request $request)
	{
		$post_id = (int)$request['id'];
		$module_id = sanitize_key((string)$request['module_id']);
		if (!Registry::is_valid_id($module_id) || !Registry::is_content_module($module_id)) {
			return new \WP_Error('cr_invalid_module', '模块无效。', ['status' => 400]);
		}

		$options = Settings::get_options();
		if (!Capabilities::is_module_available($module_id, $options)) {
			return new \WP_Error('cr_pro_required', '该模块仅 Pro 可用。', ['status' => 403]);
		}
		$modules_cfg = ModulesConfig::normalize_modules_config($options['modules'] ?? null);
		$generator = new V1Generator($options);
		$meta = MetaStore::get($post_id);
		$target_ids = $generator->get_target_module_ids($meta);
		if (!in_array($module_id, $target_ids, true)) {
			return new \WP_Error('cr_module_not_in_page_type', '该模块不属于当前页面类型的模块组合。', ['status' => 400]);
		}

		$data = $request->get_param('data');
		$clean = Sanitizer::sanitize_module_data($module_id, is_array($data) ? $data : []);
		MetaStore::touch_edited($post_id, $module_id, $clean);
		SummaryExcerptWriter::maybe_write($post_id, $modules_cfg, $module_id, $clean);

		return Meta::get_meta($request);
	}
}

