<?php

declare(strict_types=1);

namespace ContentReady\Rest\Post\Modules;

final class SummaryExcerptWriter
{
	public static function maybe_write(int $post_id, array $modules_cfg, string $module_id, array $data): void
	{
		if ($module_id !== 'summary') {
			return;
		}

		$cfg = is_array($modules_cfg['summary'] ?? null) ? $modules_cfg['summary'] : [];
		$mode = sanitize_key((string)($cfg['summary_excerpt'] ?? 'off'));
		if (!in_array($mode, ['off', 'force', 'compat'], true)) {
			$mode = 'off';
		}
		if ($mode === 'off') {
			return;
		}

		$text = sanitize_text_field((string)($data['text'] ?? ''));
		$text = trim((string)preg_replace('/\\s+/u', ' ', $text));
		if ($text === '') {
			return;
		}

		$post = get_post($post_id);
		if (!$post) {
			return;
		}

		$current = trim((string)$post->post_excerpt);
		if ($mode === 'compat' && $current !== '') {
			return;
		}

		if ($current === $text) {
			return;
		}

		wp_update_post([
			'ID' => $post_id,
			'post_excerpt' => $text,
		]);
	}
}

