<?php

declare(strict_types=1);

namespace ContentReady\Rest\Post;

use ContentReady\Checks\Checker;
use ContentReady\Frontend\StructuredData;

final class Checks
{
	public static function check_post(\WP_REST_Request $request)
	{
		$post_id = (int)$request['id'];
		return rest_ensure_response([
			'post_id' => $post_id,
			'result' => Checker::check_post($post_id),
		]);
	}

	public static function structured_preview(\WP_REST_Request $request)
	{
		$post_id = (int)$request['id'];
		return rest_ensure_response(StructuredData::preview($post_id));
	}
}

