<?php

declare(strict_types=1);

namespace ContentReady\Rest;

use ContentReady\Rest\Assessment\PostAssessment;

final class AssessmentController
{
	public static function register(): void
	{
		register_rest_route(
			Routes::REST_NAMESPACE,
				'/assessment/post/(?P<id>\\d+)',
				[
					'methods' => \WP_REST_Server::CREATABLE,
					'permission_callback' => [self::class, 'can_assess'],
					'callback' => [PostAssessment::class, 'assess'],
					'args' => [
						'id' => [
							'required' => true,
							'validate_callback' => static function ($value): bool {
							return is_numeric($value) && (int)$value > 0;
						},
					],
				],
			]
		);
	}

	public static function can_assess(\WP_REST_Request $request): bool
	{
		$post_id = (int)$request['id'];
		return $post_id > 0 && current_user_can('manage_options') && current_user_can('edit_post', $post_id);
	}
}
