<?php

declare(strict_types=1);

namespace ContentReady\Rest\Assessment;

final class Suggestions
{
	public static function default_suggestions(int $post_id, string $blocked_reason): array
	{
		$suggestions = [];

		$edit_url = get_edit_post_link($post_id, 'url');
		if (is_string($edit_url) && $edit_url !== '') {
			$suggestions[] = [
				'label' => '打开该文章编辑器',
				'url' => $edit_url,
			];
		}

		if ($blocked_reason === 'auto_not_checked_yet') {
			$suggestions[] = [
				'label' => '提示：智能兼容需先完成兼容性检查',
				'url' => admin_url('admin.php?page=content-ready-settings&tab=advanced'),
			];
		}

		return array_merge($suggestions, [
			[
				'label' => '打开设置（模块与输出）',
				'url' => admin_url('admin.php?page=content-ready-settings&tab=modules_output'),
			],
			[
				'label' => '打开设置（高级/维护）',
				'url' => admin_url('admin.php?page=content-ready-settings&tab=advanced'),
			],
		]);
	}

	public static function format_structured_block_warning(string $blocked_reason): string
	{
		switch ($blocked_reason) {
			case 'structured_disabled':
				return '结构化输出已关闭（设置 → 模块与输出）。';
			case 'no_objects_enabled':
				return '结构化输出：未选择任何输出对象（设置 → 模块与输出）。';
			case 'auto_not_checked_yet':
				return '结构化输出：处于“智能兼容”，正在检查是否与其他结构化重复；完成前暂不输出（可稍后刷新前台；如需立即输出可切换为“强制输出”（Pro））。';
			case 'auto_check_failed':
				return '结构化输出：兼容性检查失败，前端已暂停输出（可先排查抓取失败/安全插件/loopback/WAF）。';
			case 'auto_conflict_detected':
				return '结构化输出：检测到重复结构化输出，前端已暂停输出（可关闭 SEO 插件的结构化输出（Schema/JSON-LD），或切换为“强制输出”（Pro））。';
			default:
				return '结构化输出：前端不会输出（原因：' . $blocked_reason . '）。';
		}
	}
}

