<?php

declare(strict_types=1);

namespace ContentReady\Rest\Assessment;

final class JsonLdAnalyzer
{
	public static function analyze(string $html): array
	{
		$total = 0;
		$cr = 0;
		$other = 0;
		$invalid = 0;
		$types = [];

		if (preg_match_all('/<script\\b([^>]*)type=[\"\\\']application\\/ld\\+json[\"\\\']([^>]*)>(.*?)<\\/script>/is', $html, $matches, PREG_SET_ORDER)) {
			foreach ($matches as $row) {
				$total++;

				$attrs = strtolower((string)($row[1] ?? '')) . ' ' . strtolower((string)($row[2] ?? ''));
				$is_cr = strpos($attrs, 'data-cr-jsonld') !== false;
				if ($is_cr) {
					$cr++;
				} else {
					$other++;
				}

				$raw = (string)($row[3] ?? '');
				$decoded = json_decode($raw, true);
				if ($decoded === null && trim($raw) !== '' && strtolower(trim($raw)) !== 'null') {
					$invalid++;
					continue;
				}
				self::collect_types($decoded, $types);
			}
		}

		arsort($types);
		return [
			'total_scripts' => $total,
			'cr_scripts' => $cr,
			'other_scripts' => $other,
			'invalid_json' => $invalid,
			'types' => $types,
		];
	}

	private static function collect_types($value, array &$types): void
	{
		if (!is_array($value)) {
			return;
		}

		if (isset($value['@type'])) {
			$t = $value['@type'];
			if (is_string($t) && $t !== '') {
				$types[$t] = (int)($types[$t] ?? 0) + 1;
			} elseif (is_array($t)) {
				foreach ($t as $one) {
					if (is_string($one) && $one !== '') {
						$types[$one] = (int)($types[$one] ?? 0) + 1;
					}
				}
			}
		}

		foreach ($value as $v) {
			self::collect_types($v, $types);
		}
	}
}

