<?php

declare(strict_types=1);

namespace ContentReady\Rest\Assessment;

final class ContentInjectionAnalyzer
{
	public static function analyze(string $html): array
	{
		return self::analyze_with_base($html, []);
	}

	public static function analyze_with_base(string $html, array $base): array
	{
		$count = preg_match_all('/\\bcr-module\\b/', $html, $m);
		$base['found_cr_modules'] = $count > 0;
		$base['cr_module_count'] = (int)$count;
		return $base;
	}
}

