<?php

declare(strict_types=1);

namespace ContentReady;

use ContentReady\Anchors\HeadingAnchorGenerator;
use ContentReady\Automation\AutoGeo;
use ContentReady\Automation\Backfill;
use ContentReady\Admin\DeactivationFeedback;
use ContentReady\Admin\Notices;
use ContentReady\Admin\Settings;
use ContentReady\Checks\AutoChecker;
use ContentReady\Compat\JsonLdDetector;
use ContentReady\Editor\Classic;
use ContentReady\Editor\Gutenberg;
use ContentReady\Frontend\Renderer;
use ContentReady\Frontend\StructuredData;
use ContentReady\Licensing\LicenseAdmin;
use ContentReady\Licensing\LicenseRuntime;
use ContentReady\Licensing\QuotaRuntime;
use ContentReady\Rest\Routes;
use ContentReady\SiteEntrances\LlmsTxt;
use ContentReady\SiteEntrances\WpSitemapController;
use ContentReady\Toc\TocGenerator;
use ContentReady\Telemetry\TelemetryRuntime;
use ContentReady\Updates\Updater;

final class Plugin
{
        public static function init(): void
        {
                add_action('init', [self::class, 'on_init']);
                register_activation_hook(CR_PLUGIN_FILE, [self::class, 'on_activate']);
                register_deactivation_hook(CR_PLUGIN_FILE, [self::class, 'on_deactivate']);
        }

        public static function on_activate(): void
        {
                Settings::maybe_seed_defaults();
                DeactivationFeedback::on_activate();
                TelemetryRuntime::on_activate();
        }

        public static function on_deactivate(): void
        {
                TelemetryRuntime::on_deactivate();
        }

        public static function on_init(): void
        {
                Settings::register();
                Notices::register();
                DeactivationFeedback::register();
                TelemetryRuntime::register();
                LicenseRuntime::register();
                QuotaRuntime::register();
                LicenseAdmin::register();
                Routes::register();

		Gutenberg::register();
		Classic::register();

		Renderer::register();
		StructuredData::register();
		LlmsTxt::register();
		WpSitemapController::register();
		JsonLdDetector::register();
		HeadingAnchorGenerator::register();
		TocGenerator::register();
		AutoChecker::register();
		AutoGeo::register();
		Backfill::register();
		Updater::register();
	}
}
