<?php

declare(strict_types=1);

namespace ContentReady\Licensing;

final class LicenseRuntime
{
	private const VERSION_OPTION_KEY = 'cr_license_checked_version_v1';
	private static bool $is_refreshing = false;

	public static function register(): void
	{
		add_action('init', [self::class, 'maybe_refresh_on_version_change'], 20);
	}

	public static function refresh_after_settings_saved(): void
	{
		self::refresh_now(true, 'settings_save');
	}

	public static function maybe_refresh_on_version_change(): void
	{
		$current_version = defined('CR_VERSION') ? (string)CR_VERSION : '';
		$current_version = trim($current_version);
		if ($current_version === '') {
			return;
		}

		$last_version = (string)get_option(self::VERSION_OPTION_KEY, '');
		if ($last_version === $current_version) {
			return;
		}

		self::refresh_now(true, 'version_update');
		update_option(self::VERSION_OPTION_KEY, $current_version, false);
	}

	public static function refresh_now(bool $force, string $context): bool
	{
		if (self::$is_refreshing) {
			return false;
		}
		self::$is_refreshing = true;
		try {
			return LicenseGate::refresh_and_persist($force, $context);
		} finally {
			self::$is_refreshing = false;
		}
	}
}
