<?php

declare(strict_types=1);

namespace ContentReady\Licensing;

final class LicenseAdmin
{
	public static function register(): void
	{
		add_action('admin_post_cr_verify_license', [self::class, 'handle_verify']);
	}

	public static function handle_verify(): void
	{
		if (!current_user_can('manage_options')) {
			wp_die(esc_html__('You do not have permission to access this page.', 'content-ready'));
		}

		check_admin_referer('cr_verify_license');

		$options = LicenseGate::options(true, 'manual');

		$status = sanitize_key((string)($options['license']['status'] ?? 'unverified'));
		$notice = $status === 'active' ? 'cr_license_verified' : 'cr_license_verify_failed';

		$url = add_query_arg(
			['page' => 'content-ready-settings', 'tab' => 'license', 'cr_notice' => $notice],
			admin_url('admin.php')
		);
		wp_safe_redirect($url);
		exit;
	}
}

