<?php

declare(strict_types=1);

namespace ContentReady\Licensing\Capabilities;

use ContentReady\Licensing\Capabilities;
use ContentReady\Modules\Registry;

final class ClientCapsBuilder
{
	/**
	 * 提供给前端脚本/REST 的最小能力集（不包含敏感信息）。
	 */
	public static function build(array $options): array
	{
		$plan = Capabilities::plan($options);
		$is_pro = $plan !== Capabilities::PLAN_FREE;

		$module_plans = [];
		foreach (Registry::all_ids() as $module_id) {
			if (!Registry::is_content_module($module_id)) {
				continue;
			}
			$module_plans[$module_id] = Capabilities::module_plan($module_id);
		}

		$features = [];
		foreach (Capabilities::feature_definitions() as $key => $def) {
			$features[$key] = !empty($def['pro_only']) ? $is_pro : true;
		}

		return [
			'plan' => $plan,
			'features' => $features,
			'modules' => $module_plans,
		];
	}
}

