<?php

declare(strict_types=1);

namespace ContentReady\Licensing\AutomationGate;

final class TicketCache
{
	/**
	 * @return array{ticket:string,expires_at:int,checked_at:int}
	 */
	public static function read(string $option_key): array
	{
		$cached = get_option($option_key, []);
		$cached = is_array($cached) ? $cached : [];

		return [
			'ticket' => sanitize_text_field((string)($cached['ticket'] ?? '')),
			'expires_at' => (int)($cached['expires_at'] ?? 0),
			'checked_at' => (int)($cached['checked_at'] ?? 0),
		];
	}

	public static function clear(string $option_key): void
	{
		update_option($option_key, [
			'ticket' => '',
			'expires_at' => 0,
			'checked_at' => time(),
		], false);
	}

	public static function write(string $option_key, string $ticket, int $expires_at): void
	{
		update_option($option_key, [
			'ticket' => sanitize_text_field($ticket),
			'expires_at' => (int)$expires_at,
			'checked_at' => time(),
		], false);
	}
}

