<?php

declare(strict_types=1);

namespace ContentReady\Licensing\AutomationGate;

final class NoticeStore
{
	public static function record(string $option_key, string $context, string $reason, string $message): void
	{
		update_option($option_key, [
			'at' => time(),
			'seen_at' => 0,
			'context' => sanitize_key($context),
			'reason' => sanitize_key($reason),
			'message' => sanitize_text_field($message),
		], false);
	}
}

