<?php

declare(strict_types=1);

namespace ContentReady\Licensing\AutomationGate;

final class MessageBuilder
{
	public static function message_for(string $context, string $body): string
	{
		$label = self::context_label($context);

		$tail = '';
		if (sanitize_key($context) === 'automation_auto_geo') {
			$tail = '；不影响文章发布';
		}

		return 'Content Ready：' . $label . ' 未执行（' . $body . $tail . '）';
	}

	public static function status_to_human(string $status, string $base_domain): string
	{
		switch ($status) {
			case 'disabled':
				return '授权已禁用（自动化已跳过）。';
			case 'invalid_key':
				return 'License Key 无效（自动化已跳过）。';
			case 'invalid_domain':
				return $base_domain !== ''
					? ('域名不匹配（允许域：' . $base_domain . '）（自动化已跳过）。')
					: '域名不匹配（自动化已跳过）。';
			case 'pro_required':
				return '当前授权非 Pro（自动化已跳过）。';
			default:
				return '无法通过在线校验（自动化已跳过）。';
		}
	}

	private static function context_label(string $context): string
	{
		$context = sanitize_key($context);
		switch ($context) {
			case 'automation_auto_geo':
				return '发布时自动生成 GEO';
			case 'automation_backfill':
				return '老文章回填';
			default:
				return '自动化';
		}
	}
}

