<?php

declare(strict_types=1);

namespace ContentReady\Licensing\AutomationGate;

use ContentReady\Admin\Settings;

final class LicenseStatusSync
{
	/**
	 * 票据成功时：同步到本地 license（用于 Pro 能力归一化 + 每日配额）。
	 */
	public static function apply_active(array $raw, string $plan, string $base_domain, string $message, int $quota_daily_limit, int $expires_at): void
	{
		$license = is_array($raw['license'] ?? null) ? $raw['license'] : [];

		$plan = sanitize_key($plan);
		if (!in_array($plan, ['pro', 'max'], true)) {
			$plan = 'pro';
		}

		$license['checked_at'] = time();
		$license['status'] = 'active';
		$license['plan'] = $plan;
		$license['base_domain'] = strtolower(trim($base_domain));
		$license['last_message'] = $message;
		$license['last_http_status'] = 200;
		$license['last_error'] = '';
		$license['quota_daily_limit'] = max(0, min(100000, $quota_daily_limit));
		$license['last_ok_at'] = time();
		$license['last_ok_plan'] = $plan;
		$license['expires_at'] = max(time() + 60, $expires_at);

		$raw['license'] = $license;
		Settings::update_options($raw);
	}

	/**
	 * 票据接口返回了“确定性”状态时，同步到本地 license（用于禁用立即生效）。
	 */
	public static function apply_definitive(array $raw, string $status, string $plan, string $base_domain, string $message): void
	{
		unset($plan);

		if (!in_array($status, ['disabled', 'invalid_key', 'invalid_domain', 'pro_required'], true)) {
			return;
		}

		$license = is_array($raw['license'] ?? null) ? $raw['license'] : [];
		$license['checked_at'] = time();
		$license['base_domain'] = strtolower(trim($base_domain));
		$license['last_message'] = $message;
		$license['last_http_status'] = 200;
		$license['last_error'] = '';

		if ($status === 'pro_required') {
			$license['status'] = 'active';
			$license['plan'] = 'free';
			$license['expires_at'] = time() + 60;
			$raw['license'] = $license;
			Settings::update_options($raw);
			return;
		}

		$license['status'] = $status;
		$license['plan'] = 'free';
		$license['expires_at'] = time() + 60;
		$license['grace_until'] = 0;
		$raw['license'] = $license;

		Settings::update_options($raw);
	}
}

