<?php

declare(strict_types=1);

namespace ContentReady\Generator;

final class V1Generator
{
	private AiGenerator $ai;
	private LocalGenerator $local;

	public function __construct(array $options)
	{
		$this->ai = new AiGenerator($options);
		$this->local = new LocalGenerator($options);
	}

	public function is_ai_configured(): bool
	{
		return $this->ai->is_configured();
	}

	public function get_ai_last_error(): string
	{
		return $this->ai->get_last_error();
	}

	public function get_target_module_ids(array $meta): array
	{
		return $this->ai->get_target_module_ids($meta);
	}

	public function requires_ai(string $module_id): bool
	{
		return !in_array($module_id, ['last_updated', 'toc'], true);
	}

	public function generate_module(int $post_id, string $module_id, array $meta): array
	{
		if (!$this->requires_ai($module_id)) {
			return $this->local->generate_module($post_id, $module_id, $meta);
		}
		return $this->ai->generate_module($post_id, $module_id, $meta);
	}
}
