<?php

declare(strict_types=1);

namespace ContentReady\Generator\Ai;

final class PayloadExtractor
{
	public static function extract(string $module_id, array $json): array
	{
		switch ($module_id) {
			case 'summary':
				return ['text' => (string)($json['text'] ?? '')];
			case 'verdict':
				return ['text' => (string)($json['text'] ?? '')];
			case 'tldr':
			case 'limitations':
				return ['items' => is_array($json['items'] ?? null) ? $json['items'] : []];
			case 'faq':
				return ['items' => is_array($json['items'] ?? null) ? $json['items'] : []];
			case 'references':
				return ['items' => is_array($json['items'] ?? null) ? $json['items'] : []];
			case 'table':
				return [
					'caption' => (string)($json['caption'] ?? ''),
					'columns' => is_array($json['columns'] ?? null) ? $json['columns'] : [],
					'rows' => is_array($json['rows'] ?? null) ? $json['rows'] : [],
					'notes' => (string)($json['notes'] ?? ''),
				];
			case 'slug_suggestions':
				return [
					'suggestions' => is_array($json['suggestions'] ?? null) ? $json['suggestions'] : [],
				];
			default:
				return [];
		}
	}
}

