<?php

declare(strict_types=1);

namespace ContentReady\Generator\Ai;

final class ContextBuilder
{
	public static function build(\WP_Post $post, string $scope, string $output_mode = 'normal', int $budget = 0): array
	{
		$title = (string)get_the_title($post);
		$excerpt = (string)get_the_excerpt($post);
		$content = (string)$post->post_content;

		$content_text = trim(wp_strip_all_tags($content));
		$excerpt_text = trim(wp_strip_all_tags($excerpt));

		$base = [
			'_output_mode' => $output_mode,
			'_budget'      => $budget,
		];

		if ($scope === 'title_summary') {
			return array_merge($base, [
				'title'   => $title,
				'summary' => $excerpt_text !== '' ? $excerpt_text : wp_trim_words($content_text, 120, '…'),
			]);
		}

		if ($scope === 'selected_modules') {
			return array_merge($base, [
				'title'   => $title,
				'summary' => $excerpt_text !== '' ? $excerpt_text : wp_trim_words($content_text, 60, '…'),
			]);
		}

		return array_merge($base, [
			'title'   => $title,
			'excerpt' => $excerpt_text,
			'content' => $content_text,
		]);
	}
}

