<?php

declare(strict_types=1);

namespace ContentReady\Frontend\StructuredData;

final class StatusRecorder
{
	public static function record_scope_status(string $scope, string $mode, bool $would_output, string $blocked_reason, int $other_scripts): void
	{
		$scope = sanitize_key((string)$scope);
		if ($scope === '' || $scope === 'other') {
			return;
		}

		$key = 'cr_jsonld_scope_status_v1';
		$now = time();
		$data = get_transient($key);
		$data = is_array($data) ? $data : [];
		$scopes = is_array($data['scopes'] ?? null) ? $data['scopes'] : [];
		$prev = is_array($scopes[$scope] ?? null) ? $scopes[$scope] : [];
		$prev_at = (int)($prev['checked_at'] ?? 0);

		$same = isset($prev['mode'], $prev['would_output'], $prev['blocked_reason'], $prev['other_scripts'])
			&& (string)$prev['mode'] === (string)$mode
			&& (bool)$prev['would_output'] === (bool)$would_output
			&& (string)$prev['blocked_reason'] === (string)$blocked_reason
			&& (int)$prev['other_scripts'] === (int)$other_scripts;

		// 节流：5 分钟内且状态未变化，不重复写入。
		if ($prev_at > 0 && ($now - $prev_at) < 300 && $same) {
			return;
		}

		$scopes[$scope] = [
			'checked_at' => $now,
			'mode' => sanitize_key((string)$mode),
			'would_output' => $would_output ? 1 : 0,
			'blocked_reason' => sanitize_key((string)$blocked_reason),
			'other_scripts' => max(0, (int)$other_scripts),
		];
		$data['scopes'] = $scopes;
		$data['updated_at'] = $now;

		set_transient($key, $data, 7 * DAY_IN_SECONDS);
	}
}

