<?php

declare(strict_types=1);

namespace ContentReady\Frontend\StructuredData;

final class ScopeDetector
{
	public static function detect(): string
	{
		if (is_admin()) {
			return 'other';
		}

		$scope = 'other';
		if (is_front_page() || is_home()) {
			$scope = 'home';
		} elseif (is_search()) {
			$scope = 'search';
		} elseif (is_category() || is_tag() || is_tax()) {
			$scope = 'taxonomy';
		} elseif (is_singular('post')) {
			$scope = 'singular_post';
		} elseif (is_singular('page')) {
			$scope = 'singular_page';
		} elseif (is_singular()) {
			$scope = 'singular_cpt';
		}

		/**
		 * 允许第三方覆写“当前页面 scope”。
		 *
		 * @param string $scope  当前 scope（home/singular_post/singular_page/singular_cpt/taxonomy/search/other）
		 */
		$scope = (string)apply_filters('content_ready_jsonld_scope', $scope);
		$scope = sanitize_key($scope);
		return $scope !== '' ? $scope : 'other';
	}
}

