<?php

declare(strict_types=1);

namespace ContentReady\Frontend\StructuredData;

use ContentReady\Licensing\Capabilities;
use ContentReady\Meta\MetaStore;

final class OutputDecider
{
	public static function should_output_for_current_request(
		array $options,
		string $scope,
		string $mode,
		int $other_scripts,
		array $objects,
		string &$blocked_reason
	): bool {
		$so = is_array($options['structured_output'] ?? null) ? $options['structured_output'] : [];
		$enabled = !empty($so['enabled']);

		if (!$enabled || $mode === 'off') {
			$blocked_reason = 'structured_disabled';
			return false;
		}

		if ($objects === []) {
			$blocked_reason = 'no_objects_enabled';
			return false;
		}

		$is_pro = Capabilities::is_pro($options);
		if ($mode === 'force' && !$is_pro) {
			$mode = 'auto';
		}

		if ($mode === 'auto' && $other_scripts > 0) {
			$blocked_reason = 'auto_conflict_detected';
			return false;
		}

		// auto 模式：对“可被访问到的单篇页面”沿用已有的自检结果（用于覆盖 head + body 尾部的 JSON-LD）。
		if ($mode === 'auto' && is_singular()) {
			$post_id = (int)get_queried_object_id();
			if ($post_id > 0) {
				$meta = MetaStore::get($post_id);
				$checked_at = (int)($meta['compat']['checked_at'] ?? 0);
				$conflict = !empty($meta['compat']['jsonld_conflict']);
				$last_error = (string)($meta['compat']['last_error'] ?? '');

				// 自检前先不输出，避免短时间内与 SEO 插件/主题的 JSON-LD 重复。
				if ($checked_at <= 0) {
					$blocked_reason = 'auto_not_checked_yet';
					return false;
				}
				if ($last_error !== '') {
					$blocked_reason = 'auto_check_failed';
					return false;
				}
				if ($conflict) {
					$blocked_reason = 'auto_conflict_detected';
					return false;
				}
			}
		}

		return true;
	}
}

