<?php

declare(strict_types=1);

namespace ContentReady\Frontend\StructuredData;

use ContentReady\Licensing\Capabilities;
use ContentReady\PageTypes\Config as PageTypesConfig;

final class ModeResolver
{
	public static function effective_mode(array $options, string $scope): string
	{
		$so = is_array($options['structured_output'] ?? null) ? $options['structured_output'] : [];
		if (empty($so['enabled'])) {
			return 'off';
		}

		$global = sanitize_key((string)($so['mode'] ?? 'auto')); // auto | force | off
		if (!in_array($global, ['auto', 'force', 'off'], true)) {
			$global = 'auto';
		}
		$scopes = is_array($so['scopes'] ?? null) ? $so['scopes'] : [];

		$scope_mode = sanitize_key((string)($scopes[$scope] ?? 'inherit'));
		if ($scope_mode === '' || $scope_mode === 'inherit') {
			return $global;
		}

		if (!in_array($scope_mode, ['auto', 'force', 'off'], true)) {
			return $global;
		}

		return $scope_mode;
	}

	public static function object_enabled(array $options, string $object_id): bool
	{
		$so = is_array($options['structured_output'] ?? null) ? $options['structured_output'] : [];
		$objects = is_array($so['objects'] ?? null) ? $so['objects'] : [];
		return !empty($objects[$object_id]);
	}

	public static function effective_mode_for_post(array $options, string $scope, array $meta): string
	{
		$so = is_array($options['structured_output'] ?? null) ? $options['structured_output'] : [];
		if (empty($so['enabled'])) {
			return 'off';
		}

		$mode = self::effective_mode($options, $scope);
		$page_type = sanitize_key((string)($meta['page_type'] ?? 'article'));
		$strategy = PageTypesConfig::schema_strategy_for($page_type, $options);
		$page_type_mode = PageTypesConfig::normalize_schema_mode((string)($strategy['mode'] ?? 'inherit'));

		if ($page_type_mode !== 'inherit') {
			$mode = $page_type_mode;
		}

		if ($mode === 'force' && !Capabilities::is_pro($options)) {
			$mode = 'auto';
		}

		return $mode;
	}
}

