<?php

declare(strict_types=1);

namespace ContentReady\Frontend\StructuredData;

final class JsonLdHtml
{
	public static function render_objects(array $objects): string
	{
		$out = '';
		foreach ($objects as $obj) {
			if (!is_array($obj) || $obj === []) {
				continue;
			}
			$json = wp_json_encode($obj, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
			if (!is_string($json)) {
				continue;
			}
			$out .= '<script type="application/ld+json" data-cr-jsonld="1">' . $json . '</script>' . "\n";
		}
		return $out;
	}

	public static function count_other_jsonld_scripts(string $html): int
	{
		if ($html === '') {
			return 0;
		}

		$count = 0;
		if (preg_match_all('~<script\\b[^>]*type\\s*=\\s*[\"\\\']application/ld\\+json[\"\\\'][^>]*>~i', $html, $m) !== false) {
			foreach ($m[0] as $tag) {
				if (stripos((string)$tag, 'data-cr-jsonld') === false) {
					$count++;
				}
			}
		}

		return $count;
	}
}

