<?php

declare(strict_types=1);

namespace ContentReady\Frontend\Structured;

use ContentReady\Frontend\Structured\JsonLd\ArticleBuilder;
use ContentReady\Frontend\Structured\JsonLd\FaqBuilder;
use ContentReady\Frontend\Structured\JsonLd\PrimaryBuilder;
use ContentReady\Frontend\Structured\JsonLd\SiteGraphBuilder;
use ContentReady\Frontend\Structured\JsonLd\WebPageBuilder;

final class JsonLdBuilder
{
	public static function build_site_graph(array $options): array
	{
		return SiteGraphBuilder::build($options);
	}

	public static function build_webpage(array $options, string $scope, bool $with_site_graph): array
	{
		return WebPageBuilder::build_current($options, $scope, $with_site_graph);
	}

	public static function build_webpage_for_post(array $options, \WP_Post $post, bool $with_site_graph): array
	{
		return WebPageBuilder::build_for_post($options, $post, $with_site_graph);
	}

	public static function build_article(\WP_Post $post, array $options, array $meta): array
	{
		return ArticleBuilder::build($post, $options, $meta);
	}

	public static function build_primary(\WP_Post $post, array $options, array $meta, string $schema_profile): array
	{
		return PrimaryBuilder::build($post, $options, $meta, $schema_profile);
	}

	public static function build_faq(array $items, string $permalink): ?array
	{
		return FaqBuilder::build($items, $permalink);
	}
}

