<?php

declare(strict_types=1);

namespace ContentReady\Frontend\Structured\JsonLd;

final class SiteGraphBuilder
{
	public static function build(array $options): array
	{
		$site = is_array($options['site'] ?? null) ? $options['site'] : [];
		$entity = EntityResolver::build_primary_entity($site);
		$publisher_name = (string)($entity['name'] ?? EntityResolver::entity_name($site));

		$site_url = Resolver::site_url_base();
		$org_id = (string)($entity['@id'] ?? EntityResolver::entity_id($site));
		$website_id = ($site_url !== '' ? $site_url : home_url('/')) . '#website';

		$website = [
			'@type' => 'WebSite',
			'@id' => $website_id,
			'url' => $site_url !== '' ? $site_url : home_url('/'),
			'name' => $publisher_name,
			'publisher' => ['@id' => $org_id],
		];

		$locale = Resolver::resolve_site_locale($site);
		if ($locale !== '') {
			$website['inLanguage'] = $locale;
		}

		return [
			'@context' => 'https://schema.org',
			'@graph' => [$entity, $website],
		];
	}
}

