<?php

declare(strict_types=1);

namespace ContentReady\Frontend\Structured\JsonLd;

final class FaqBuilder
{
	public static function build(array $items, string $permalink): ?array
	{
		$main = [];
		foreach ($items as $it) {
			if (!is_array($it)) {
				continue;
			}
			$q = sanitize_text_field((string)($it['q'] ?? ''));
			$a_html = (string)($it['a'] ?? '');
			$a = trim(wp_strip_all_tags($a_html));
			if ($q === '' || $a === '') {
				continue;
			}
			$main[] = [
				'@type' => 'Question',
				'name' => $q,
				'acceptedAnswer' => [
					'@type' => 'Answer',
					'text' => $a,
				],
			];
		}

		if ($main === []) {
			return null;
		}

		return [
			'@context' => 'https://schema.org',
			'@type' => 'FAQPage',
			'@id' => $permalink . '#faq',
			'mainEntity' => $main,
		];
	}
}

