<?php

declare(strict_types=1);

namespace ContentReady\Frontend\ModuleRenderer;

final class Wrapper
{
	public static function wrap(string $module_id, string $anchor, string $label, string $body_html): string
	{
		$attr = ' class="cr-module cr-module--' . esc_attr($module_id) . '"';
		if ($anchor !== '') {
			$attr .= ' id="' . esc_attr($anchor) . '"';
		}

		return '<section' . $attr . '>' .
			'<h2 class="cr-module__title">' . esc_html($label) . '</h2>' .
			$body_html .
			'</section>';
	}
}

