<?php

declare(strict_types=1);

namespace ContentReady\Frontend\ModuleRenderer;

use ContentReady\Admin\Settings;

final class LastUpdatedRenderer
{
	public static function render(string $label, array $data, string $anchor): string
	{
		$date = sanitize_text_field((string)($data['date'] ?? ''));
		if ($date === '') {
			return '';
		}
		$ts = strtotime($date);
		if (!$ts) {
			return Wrapper::wrap('last_updated', $anchor, $label, '<div class="cr-module__body">' . esc_html($date) . '</div>');
		}

		$options = Settings::get_options();
		$site = is_array($options['site'] ?? null) ? $options['site'] : [];
		$fmt = (string)($site['date_format'] ?? 'wp');
		if ($fmt === '' || $fmt === 'wp') {
			$fmt = (string)get_option('date_format');
		}
		$human = wp_date($fmt, $ts);
		$datetime = wp_date('c', $ts);
		$body = '<div class="cr-module__body"><time class="cr-module__time" datetime="' . esc_attr($datetime) . '">' . esc_html($human) . '</time></div>';
		return Wrapper::wrap('last_updated', $anchor, $label, $body);
	}
}

