<?php

declare(strict_types=1);

namespace ContentReady\Checks;

use ContentReady\Admin\Settings;
use ContentReady\Meta\MetaStore;

final class AutoChecker
{
	private static bool $running = false;

	public static function register(): void
	{
		add_action('save_post', [self::class, 'run_on_save_post'], 60, 3);
	}

	public static function run_on_save_post(int $post_id, \WP_Post $post, bool $update): void
	{
		if (self::$running) {
			return;
		}
		if (wp_is_post_revision($post_id) || wp_is_post_autosave($post_id)) {
			return;
		}
		if ($post->post_status !== 'publish') {
			return;
		}
		if (!current_user_can('edit_post', $post_id)) {
			return;
		}

		$options = Settings::get_options();
		$enabled = !empty(($options['checks']['auto_on_publish'] ?? true));
		if (!$enabled) {
			return;
		}

		self::$running = true;
		try {
			$result = Checker::check_post($post_id);
			$meta = MetaStore::get($post_id);
			$meta['checks'] = is_array($meta['checks'] ?? null) ? $meta['checks'] : [];
			$meta['checks']['v1'] = [
				'ran_at' => time(),
				'result' => Checker::sanitize_result($result),
			];
			MetaStore::update($post_id, $meta);
		} finally {
			self::$running = false;
		}
	}
}

