<?php

declare(strict_types=1);

namespace ContentReady\Admin\Ui;

final class Badges
{
	public static function pro(string $title = 'Pro 功能'): string
	{
		return self::pill('pro', 'PRO', $title);
	}

	public static function ai(string $title = '将消耗 AI Token'): string
	{
		return self::pill('ai', 'AI', $title);
	}

	private static function pill(string $kind, string $text, string $title): string
	{
		$kind = sanitize_key($kind);
		$text = sanitize_text_field($text);
		$title = sanitize_text_field($title);
		return '<span class="cr-badge cr-badge--' . esc_attr($kind) . '" title="' . esc_attr($title) . '">' . esc_html($text) . '</span>';
	}
}

