<?php

declare(strict_types=1);

namespace ContentReady\Admin\Tabs;

use ContentReady\Admin\SettingsForm;
use ContentReady\Admin\SettingsSections\SiteEntrancesSection;

final class SiteEntrancesTab
{
	public static function render(array $options): void
	{
		echo '<h2 style="margin-top:16px;">站点入口</h2>';
		echo '<p class="description">用于管理 llms.txt 与 WordPress 自带 Sitemap 的最小控制，让搜索引擎/爬虫更容易发现与理解你的内容。</p>';
		SettingsForm::open('site_entrances');
		SiteEntrancesSection::render($options);
		SettingsForm::close();
	}
}

