<?php

declare(strict_types=1);

namespace ContentReady\Admin\Tabs;

use ContentReady\Admin\SettingsForm;
use ContentReady\Admin\SettingsSections\PageTypesSection;

final class PageTypesTab
{
	public static function render(array $options): void
	{
		echo '<h2 style="margin-top:16px;">' . esc_html__('页面类型规则', 'content-ready') . '</h2>';
		echo '<p class="description">适合“不同类型内容用不同模块组合 + 不同结构化策略”的站点：建议先用通用文章跑通主流程，再按需拆分。</p>';
		SettingsForm::open('page_types');
		PageTypesSection::render($options);
		SettingsForm::close();
	}
}

