<?php

declare(strict_types=1);

namespace ContentReady\Admin\Tabs;

use ContentReady\Admin\SettingsForm;
use ContentReady\Admin\SettingsSections\ModulesSection;
use ContentReady\Admin\Tabs\ModulesOutput\FrontendRows;
use ContentReady\Admin\Tabs\ModulesOutput\StructuredOutputRows;
use ContentReady\Admin\Ui\Badges;
use ContentReady\Licensing\Capabilities;

final class ModulesOutputTab
{
	public static function render(array $options): void
	{
		$is_pro = Capabilities::is_pro($options);

		echo '<h2 style="margin-top:16px;">' . esc_html__('模块与输出', 'content-ready') . '</h2>';
		echo '<p class="description">提示：模块决定你会得到哪些内容；输出决定这些内容会在哪里展示（前端/结构化）。不确定就先保持默认，试跑后再调整。</p>';
		self::render_badge_legend();

		SettingsForm::open('modules_output');

		echo '<table class="form-table" role="presentation"><tbody>';

		FrontendRows::render($options);
		StructuredOutputRows::render($options, $is_pro);

		echo '</tbody></table>';

		ModulesSection::render($options);

		SettingsForm::close();
	}

	private static function render_badge_legend(): void
	{
		echo '<p class="description" style="margin:12px 0 0;">';
		echo '<span class="cr-badge-wrap">标记：' . Badges::pro('Pro 功能（即使已解锁也会常驻标注）') . Badges::ai('将消耗 AI Token') . '</span>';
		echo '</p>';
	}
}
