<?php

declare(strict_types=1);

namespace ContentReady\Admin\Tabs\ModulesOutput;

final class StructuredOutputRows
{
	public static function render(array $options, bool $is_pro): void
	{
		echo '<tr><th scope="row">结构化输出（JSON-LD）</th><td>';
		$so_enabled = !empty($options['structured_output']['enabled']);
		echo '<label><input type="checkbox" name="structured_output_enabled" value="1"' . checked($so_enabled, true, false) . ' /> 启用</label>';
		echo '<input type="hidden" name="structured_output_present" value="1" />';

		$so_mode = sanitize_key((string)($options['structured_output']['mode'] ?? 'auto'));
		if (!in_array($so_mode, ['auto', 'force', 'off'], true)) {
			$so_mode = 'auto';
		}

		echo '<div style="margin-top:8px;">';
		echo '<span style="display:inline-block;min-width:72px;color:#111827;font-weight:600;">模式</span> ';
		if ($is_pro) {
			echo '<select name="structured_output_mode">';
			foreach (['auto' => '智能兼容（默认）', 'force' => '强制输出', 'off' => '关闭'] as $k => $label) {
				echo '<option value="' . esc_attr($k) . '"' . selected($so_mode, $k, false) . '>' . esc_html($label) . '</option>';
			}
			echo '</select>';
		} else {
			echo '<select disabled>';
			foreach (['auto' => '智能兼容（默认）', 'force' => '强制输出', 'off' => '关闭'] as $k => $label) {
				echo '<option value="' . esc_attr($k) . '"' . selected($so_mode, $k, false) . '>' . esc_html($label) . '</option>';
			}
			echo '</select>';
			echo '<span style="color:#6b7280;margin-left:8px;">Free：固定为智能兼容；Pro 可选强制输出/关闭。</span>';
		}
		echo '</div>';

		$so_objects = is_array($options['structured_output']['objects'] ?? null) ? $options['structured_output']['objects'] : [];
		$so_scopes = is_array($options['structured_output']['scopes'] ?? null) ? $options['structured_output']['scopes'] : [];

		echo '<div style="margin-top:12px;">';
		echo '<div style="font-weight:600;color:#111827;margin-bottom:6px;">输出对象</div>';
		$objects_map = [
			'site_graph' => '站点基础（Entity / WebSite）',
			'webpage' => '页面信息（WebPage）',
			'article' => '主内容结构（按页面类型策略输出）',
			'faq' => 'FAQ（FAQPage）',
		];
		foreach ($objects_map as $oid => $label) {
			$checked = !empty($so_objects[$oid]);
			echo '<label style="display:inline-block;margin-right:14px;margin-bottom:6px;">';
			echo '<input type="checkbox" name="structured_output_objects[' . esc_attr($oid) . ']" value="1"' . checked($checked, true, false) . ' /> ' . esc_html($label);
			echo '</label>';
		}
		echo '<p class="description">默认全部开启。建议站点只保留一个结构化输出出口：如果你已经启用 SEO 插件/主题的 Schema/JSON-LD，请在此处或对方设置中关闭重复项。</p>';
		echo '</div>';

		echo '<div style="margin-top:12px;">';
		echo '<div style="font-weight:600;color:#111827;margin-bottom:6px;">接管范围</div>';

		$probe_redirect = add_query_arg(['page' => 'content-ready-settings', 'tab' => 'modules_output'], admin_url('admin.php'));
		$probe_url = wp_nonce_url(
			add_query_arg(['action' => 'cr_probe_jsonld', 'redirect' => $probe_redirect], admin_url('admin-post.php')),
			'cr_probe_jsonld'
		);
		$probe_nonce = wp_create_nonce('cr_probe_jsonld');
		echo '<p style="margin:6px 0 10px;">';
		echo '<a class="button" id="cr-jsonld-probe-btn" href="' . esc_url($probe_url) . '" data-cr-nonce="' . esc_attr($probe_nonce) . '">一键探测（刷新状态）</a>';
		echo '<span id="cr-jsonld-probe-msg" class="description" style="margin-left:8px;">后台会自动请求：首页/文章/页面/分类/搜索 等页面。</span>';
		echo '</p>';

		$status = get_transient('cr_jsonld_scope_status_v1');
		$status = is_array($status) ? $status : [];
		$st_scopes = is_array($status['scopes'] ?? null) ? $status['scopes'] : [];
		$st_updated_at = (int)($status['updated_at'] ?? 0);
		if ($st_updated_at > 0) {
			echo '<p class="description" style="margin:0 0 10px;">最近刷新：' . esc_html(date_i18n('Y-m-d H:i:s', $st_updated_at)) . '</p>';
		}

		$scope_labels = [
			'home' => '首页（静态首页 + 文章列表页）',
			'singular_post' => '文章页（post）',
			'singular_page' => '页面（page）',
			'singular_cpt' => '自定义内容（CPT）',
			'taxonomy' => '分类/标签页',
			'search' => '搜索结果页',
		];
		foreach ($scope_labels as $sid => $label) {
			$raw = sanitize_key((string)($so_scopes[$sid] ?? 'inherit'));
			if (!in_array($raw, ['inherit', 'auto', 'force', 'off'], true)) {
				$raw = 'inherit';
			}

			$row = is_array($st_scopes[$sid] ?? null) ? $st_scopes[$sid] : [];
			$ts = (int)($row['checked_at'] ?? 0);
			$other = (int)($row['other_scripts'] ?? 0);
			$mode = sanitize_key((string)($row['mode'] ?? ''));
			$br = sanitize_key((string)($row['blocked_reason'] ?? ''));
			$wo = !empty($row['would_output']);

			$state = '未检测';
			if ($ts > 0) {
				if ($br === 'structured_disabled') {
					$state = '已关闭';
				} elseif ($br === 'no_objects_enabled') {
					$state = '无输出对象';
				} elseif (!$wo && $br === 'auto_not_checked_yet') {
					$state = '等待自检';
				} elseif (!$wo && $br === 'auto_check_failed') {
					$state = '自检失败（已暂停）';
				} elseif (!$wo && $br === 'auto_conflict_detected') {
					$state = $other > 0 ? ('已暂停输出（当前检测到 ' . $other . ' 个其他来源的 JSON-LD）') : '已暂停输出（检测到其他来源的 JSON-LD）';
				} elseif ($wo) {
					if ($mode === 'force') {
						$state = $other > 0 ? ('强制输出中（当前检测到 ' . $other . ' 个其他来源的 JSON-LD）') : '强制输出中（未检测到其他来源的 JSON-LD）';
					} else {
						$state = '正常输出（未检测到其他来源的 JSON-LD）';
					}
				} else {
					$state = $br !== '' ? ('已暂停（' . $br . '）') : '已暂停';
				}
				$state .= ' · ' . date_i18n('H:i:s', $ts);
			}
			echo '<div style="margin-bottom:8px;">';
			echo '<span style="display:inline-block;min-width:220px;">' . esc_html($label) . '</span>';
			if ($is_pro) {
				echo '<select name="structured_output_scopes[' . esc_attr($sid) . ']">';
				foreach (['inherit' => '继承全局模式', 'auto' => '智能兼容', 'force' => '强制输出（Pro）', 'off' => '关闭'] as $k => $t) {
					echo '<option value="' . esc_attr($k) . '"' . selected($raw, $k, false) . '>' . esc_html($t) . '</option>';
				}
				echo '</select>';
			} else {
				// Free：全局固定为“智能兼容”，scope 仅提供启用/关闭。
				$free_val = ($raw === 'off') ? 'off' : 'inherit';
				echo '<select name="structured_output_scopes[' . esc_attr($sid) . ']">';
				foreach (['inherit' => '启用（智能兼容）', 'off' => '关闭'] as $k => $t) {
					echo '<option value="' . esc_attr($k) . '"' . selected($free_val, $k, false) . '>' . esc_html($t) . '</option>';
				}
				echo '</select>';
			}
			echo '<span class="description" style="margin-left:8px;" data-cr-jsonld-scope="' . esc_attr($sid) . '">' . esc_html($state) . '</span>';
			echo '</div>';
		}
		echo '<p class="description">提示：某个范围关闭后，该类页面将不输出任何结构化（即使其他对象/模块有数据）。</p>';
		echo '</div>';

		echo '<p class="description">智能兼容会在检测到站点已有其他插件/主题的结构化输出时自动暂停本插件输出，避免重复（重复可能影响富结果/收录表现）。</p>';
		echo '<p class="description">提示：单篇内容（文章/页面/CPT）会做一次兼容性自检；自检完成前，智能兼容可能会短暂不输出结构化（通常数十秒，属正常现象）。</p>';
		echo '</td></tr>';
	}
}

