<?php

declare(strict_types=1);

namespace ContentReady\Admin\Tabs\ModulesOutput;

final class FrontendRows
{
	public static function render(array $options): void
	{
		echo '<tr><th scope="row">前端渲染（可视化模块）</th><td>';
		$inject = !empty($options['frontend']['inject_enabled']);
		echo '<label><input type="checkbox" name="frontend_inject_enabled" value="1"' . checked($inject, true, false) . ' /> 启用前端渲染（在正文中展示模块）</label>';
		echo '<p class="description">开启后，插件会将已生成模块显示在文章/页面的正文区域。关闭后仍可在编辑器内使用模块与检查；结构化输出可独立开关。</p>';
		echo '</td></tr>';

		echo '<tr><th scope="row">前端样式</th><td>';
		$css = !empty($options['frontend']['css_enabled']);
		echo '<label><input type="checkbox" name="frontend_css_enabled" value="1"' . checked($css, true, false) . ' /> 启用轻量预设样式</label>';
		echo '<p class="description">提供基础排版（标题/列表/表格等）。如你的主题已有完整样式，可关闭以避免冲突。</p>';
		echo '</td></tr>';
	}
}

