<?php

declare(strict_types=1);

namespace ContentReady\Admin\Tabs;

use ContentReady\Admin\SettingsForm;
use ContentReady\Admin\Ui\Badges;
use ContentReady\Admin\Ui\PlanCompare;
use ContentReady\Updates\Updater;

final class LicenseTab
{
	public static function render(array $options): void
	{
		echo '<h2 style="margin-top:16px;">' . esc_html__('许可证', 'content-ready') . ' <span class="cr-badge-wrap">' . Badges::pro() . '</span></h2>';
		echo '<p class="description">许可证用于解锁 Pro（自动化/更多模块/更高配额等）。</p>';
		SettingsForm::open('license');

		$key = (string)($options['license']['key'] ?? '');
		$status = sanitize_key((string)($options['license']['status'] ?? 'unlicensed'));
		$plan = sanitize_key((string)($options['license']['plan'] ?? 'free'));
		$grant_type = sanitize_key((string)($options['license']['grant_type'] ?? ''));
		$base_domain = sanitize_text_field((string)($options['license']['base_domain'] ?? ''));
		$checked_at = (int)($options['license']['checked_at'] ?? 0);
		$expires_at = (int)($options['license']['expires_at'] ?? 0);
		$last_error = sanitize_text_field((string)($options['license']['last_error'] ?? ''));
		$status_label = [
			'unlicensed' => '未填写',
			'unverified' => '待校验',
			'active' => '已激活',
			'disabled' => '已禁用',
			'invalid_key' => 'Key 无效',
			'invalid_domain' => '域名不匹配',
			'error' => '校验失败（网络/服务）',
		][$status] ?? $status;

		echo '<p class="description">v1.1：填写 key 后必须通过在线校验才会解锁 Pro；Key 绑定“主域名”，允许无限子域。校验失败会直接回到 Free。</p>';
		echo '<table class="form-table" role="presentation"><tbody>';
		echo '<tr><th scope="row"><label for="cr_license_key">License Key（许可证密钥）</label></th><td>';
		echo '<input class="regular-text" id="cr_license_key" name="license_key" value="' . esc_attr($key) . '" />';
		echo '<p class="description">状态：' . esc_html($status_label) . '；套餐：' . esc_html($plan !== '' ? $plan : 'free') . '</p>';
		$grant_label = [
			'paid' => '付费',
			'gift' => '赠送',
			'promo' => '活动',
			'internal' => '内部',
		][$grant_type] ?? '';
		if ($grant_label !== '') {
			echo '<p class="description">来源：' . esc_html($grant_label) . '</p>';
		}
		if ($base_domain !== '') {
			echo '<p class="description">绑定域名：' . esc_html($base_domain) . '（允许其所有子域）</p>';
		}
		if ($last_error !== '') {
			echo '<p class="description" style="color:#b91c1c;">最近错误：' . esc_html($last_error) . '</p>';
		}
		echo '</td></tr>';
		echo '</tbody></table>';

		SettingsForm::close();

		// 手动触发“立即校验”（不修改 key）。
		echo '<form method="post" action="' . esc_url(admin_url('admin-post.php')) . '">';
		wp_nonce_field('cr_verify_license');
		echo '<input type="hidden" name="action" value="cr_verify_license" />';
		submit_button('立即校验', 'secondary', 'submit', false);
		echo '</form>';

		$cached = Updater::get_cached_update_info();
		$cached_version = sanitize_text_field((string)($cached['version'] ?? ''));
		$cached_details_url = isset($cached['details_url']) ? esc_url_raw((string)$cached['details_url']) : '';
		$cached_checked_at = (int)($cached['checked_at'] ?? 0);
		$current_version = defined('CR_VERSION') ? (string)CR_VERSION : '';

		echo '<div style="margin-top:16px;padding:12px;border:1px solid #e5e7eb;background:#fff;">';
		echo '<p style="margin:0 0 8px;font-weight:600;">更新</p>';
		echo '<p class="description" style="margin:0 0 8px;">';
		echo '当前版本：' . esc_html($current_version !== '' ? $current_version : 'unknown') . '；';
		echo '最新版本：' . esc_html($cached_version !== '' ? $cached_version : '未检查') . '；';
		echo '上次检查：' . esc_html($cached_checked_at > 0 ? wp_date('Y-m-d H:i', $cached_checked_at) : '无');
		echo '</p>';

		echo '<form method="post" action="' . esc_url(admin_url('admin-post.php')) . '">';
		wp_nonce_field('cr_check_updates');
		echo '<input type="hidden" name="action" value="cr_check_updates" />';
		submit_button('检查更新', 'secondary', 'submit', false);
		echo ' <a class="button" href="' . esc_url(admin_url('update-core.php')) . '">打开 WordPress 更新</a>';
		$download_page_url = $cached_details_url !== '' ? $cached_details_url : 'https://cr-license.imsxx.com/v1/update/details';
		echo ' <a class="button" href="' . esc_url($download_page_url) . '" target="_blank" rel="noopener noreferrer">查看更新日志（下载）</a>';
		echo '</form>';

		echo '<p class="description" style="margin:8px 0 0;">提示：检查更新只刷新状态，不会自动安装；下载请打开更新日志（含下载链接）。</p>';
		echo '</div>';

		PlanCompare::render($options);
	}
}
