<?php

declare(strict_types=1);

namespace ContentReady\Admin\Tabs;

use ContentReady\Admin\SettingsForm;
use ContentReady\Admin\Tabs\Basic\BehaviorRows;
use ContentReady\Admin\Tabs\Basic\FormatRows;
use ContentReady\Admin\Tabs\Basic\SiteRows;
use ContentReady\Licensing\Capabilities;

final class BasicTab
{
	public static function render(array $options): void
	{
		$is_pro = Capabilities::is_pro($options);
		$site = is_array($options['site'] ?? null) ? $options['site'] : [];
		$ui = is_array($options['ui'] ?? null) ? $options['ui'] : [];

		echo '<h2 style="margin-top:16px;">' . esc_html__('基础设置', 'content-ready') . '</h2>';
		echo '<p class="description">用于填写站点基础信息（会影响结构化输出/作者显示等）。不确定就先保持默认，后续再补齐也可以。</p>';
		SettingsForm::open('basic');

		echo '<table class="form-table" role="presentation"><tbody>';

		SiteRows::render($site, $is_pro);
		FormatRows::render($site, $is_pro);
		BehaviorRows::render($options, $ui);

		echo '</tbody></table>';
		SettingsForm::close();
	}
}
