<?php

declare(strict_types=1);

namespace ContentReady\Admin\Tabs\Basic;

use ContentReady\Admin\Ui\Badges;
use ContentReady\Util\Locale;

final class SiteRows
{
	public static function render(array $site, bool $is_pro): void
	{
		echo '<tr><th scope="row"><label for="cr_site_display_name">网站名称（展示用）</label></th><td>';
		echo '<input class="regular-text" id="cr_site_display_name" name="site_display_name" value="' . esc_attr((string)($site['display_name'] ?? '')) . '" />';
		echo '<p class="description">用于结构化输出的 publisher/name；留空则默认读取 WordPress「设置 → 常规」中的站点标题（不修改全站设置）。</p>';
		echo '</td></tr>';

		echo '<tr><th scope="row"><label for="cr_site_logo_url">网站 Logo URL（可选）</label></th><td>';
		$logo_url = (string)($site['logo_url'] ?? '');
		echo '<div style="display:flex;gap:8px;align-items:center;max-width:760px;">';
		echo '<input class="regular-text" id="cr_site_logo_url" name="site_logo_url" value="' . esc_attr($logo_url) . '" placeholder="https://example.com/logo.png" style="flex:1;min-width:220px;" />';
		echo '<button type="button" class="button" id="cr_site_logo_pick">从媒体库选择</button>';
		echo '<button type="button" class="button" id="cr_site_logo_clear">清除</button>';
		echo '</div>';
		echo '<div id="cr_site_logo_preview" style="margin-top:8px;">';
		if ($logo_url !== '') {
			echo '<img src="' . esc_url($logo_url) . '" alt="" style="max-width:120px;height:auto;border:1px solid #e5e7eb;border-radius:8px;padding:6px;background:#fff;" />';
		}
		echo '</div>';
		echo '<p class="description">用于结构化输出 publisher/logo（ImageObject.url）。推荐尺寸：正方形 ≥ 512×512（清晰度更好）。如未填写：优先使用“站点身份 → 站点图标”；若仍无则尝试站点根目录的 favicon.ico；都没有则不输出 logo。</p>';
		echo '</td></tr>';

		echo '<tr><th scope="row"><label for="cr_site_locale">默认语言 / 地区</label></th><td>';
		$selected_locale = (string)($site['locale'] ?? '');
		$current = Locale::wp_locale_to_bcp47((string)get_locale());
		$available = function_exists('get_available_languages') ? get_available_languages() : [];
		$raw_list = array_values(array_unique(array_merge([(string)get_locale()], is_array($available) ? $available : [])));
		$map = [];
		foreach ($raw_list as $wp_locale) {
			$tag = Locale::wp_locale_to_bcp47((string)$wp_locale);
			if ($tag === '') {
				continue;
			}
			$map[$tag] = (string)$wp_locale;
		}
		ksort($map);

		echo '<select id="cr_site_locale" name="site_locale">';
		echo '<option value="">' . esc_html__('跟随站点语言（WordPress）', 'content-ready') . '</option>';
		foreach ($map as $tag => $wp_locale) {
			$label = $tag . ($wp_locale !== '' ? ('（' . $wp_locale . '）') : '');
			echo '<option value="' . esc_attr($tag) . '"' . selected($selected_locale, $tag, false) . '>' . esc_html($label) . '</option>';
		}
		echo '</select>';
		echo '<p class="description">用于结构化输出 inLanguage。当前站点语言：' . esc_html($current !== '' ? $current : (string)get_locale()) . '</p>';
		echo '</td></tr>';

		echo '<tr><th scope="row">Entity 中心 ' . Badges::pro('Entity 中心为 Pro 功能') . '</th><td>';
		if ($is_pro) {
			$entity_type = sanitize_key((string)($site['entity_type'] ?? 'organization'));
			if (!in_array($entity_type, ['organization', 'person', 'local_business'], true)) {
				$entity_type = 'organization';
			}

			echo '<p style="margin-top:0;">用于定义站点在结构化输出中的“主体实体”（Entity），并与 WebSite / Article 的 publisher 一致化。</p>';
			echo '<p style="margin:8px 0;">';
			echo '<label style="display:inline-block;min-width:110px;">实体类型</label>';
			echo '<select name="site_entity_type">';
			foreach (['organization' => 'Organization（组织）', 'person' => 'Person（个人）', 'local_business' => 'LocalBusiness（本地商家）'] as $key => $label) {
				echo '<option value="' . esc_attr($key) . '"' . selected($entity_type, $key, false) . '>' . esc_html($label) . '</option>';
			}
			echo '</select>';
			echo '</p>';

			echo '<p style="margin:8px 0;">';
			echo '<label style="display:inline-block;min-width:110px;">实体名称</label>';
			echo '<input class="regular-text" name="site_entity_name" value="' . esc_attr((string)($site['entity_name'] ?? '')) . '" placeholder="留空则沿用网站名称（展示用）" />';
			echo '</p>';

			echo '<p style="margin:8px 0;">';
			echo '<label style="display:inline-block;min-width:110px;">实体 URL</label>';
			echo '<input class="regular-text" name="site_entity_url" value="' . esc_attr((string)($site['entity_url'] ?? '')) . '" placeholder="https://example.com/brand" />';
			echo '</p>';

			echo '<p style="margin:8px 0;">';
			echo '<label style="display:inline-block;min-width:110px;vertical-align:top;">SameAs</label>';
			echo '<textarea class="large-text" rows="3" name="site_entity_same_as" placeholder="每行一个 URL，例如社媒主页">' . esc_textarea((string)($site['entity_same_as'] ?? '')) . '</textarea>';
			echo '</p>';

			echo '<p style="margin:8px 0;">';
			echo '<label style="display:inline-block;min-width:110px;">联系电话</label>';
			echo '<input class="regular-text" name="site_entity_phone" value="' . esc_attr((string)($site['entity_phone'] ?? '')) . '" placeholder="仅本地商家建议填写" />';
			echo '</p>';

			echo '<p style="margin:8px 0;">';
			echo '<label style="display:inline-block;min-width:110px;">地址</label>';
			echo '<input class="regular-text" name="site_entity_address" value="' . esc_attr((string)($site['entity_address'] ?? '')) . '" placeholder="仅本地商家建议填写" />';
			echo '</p>';

			echo '<p style="margin:8px 0;">';
			echo '<label style="display:inline-block;min-width:110px;vertical-align:top;">实体简介</label>';
			echo '<textarea class="large-text" rows="2" name="site_entity_description" placeholder="用于增强结构化输出可读性（可选）">' . esc_textarea((string)($site['entity_description'] ?? '')) . '</textarea>';
			echo '</p>';

			echo '<p class="description">提示：站点 Logo 与 inLanguage 仍沿用本页上方配置；若未填写实体 URL，则默认使用站点首页。</p>';
		} else {
			echo '<span style="color:#6b7280;">Free：固定使用 Organization（站点名称 + 首页 URL）作为站点实体。</span>';
		}
		echo '</td></tr>';
	}
}

