<?php

declare(strict_types=1);

namespace ContentReady\Admin\Tabs\Basic;

use ContentReady\Admin\Ui\Badges;

final class FormatRows
{
	public static function render(array $site, bool $is_pro): void
	{
		$df = (string)($site['date_format'] ?? 'wp');
		$df_mode = $df === 'wp' ? 'wp' : 'custom';
		echo '<tr><th scope="row">日期展示格式</th><td>';
		echo '<label><input type="radio" name="site_date_format_mode" value="wp"' . checked($df_mode, 'wp', false) . ' /> 使用 WordPress 日期格式（' . esc_html((string)get_option('date_format')) . '）</label><br />';
		echo '<label><input type="radio" name="site_date_format_mode" value="custom"' . checked($df_mode, 'custom', false) . ' /> 自定义</label><br />';
		echo '<input class="regular-text" name="site_date_format_custom" value="' . esc_attr($df_mode === 'custom' ? $df : '') . '" placeholder="Y-m-d" />';
		echo '<p class="description">用于“可见更新时间”等模块显示；格式为 PHP date() 语法。</p>';
		echo '</td></tr>';

		echo '<tr><th scope="row">默认作者显示策略 ' . Badges::pro('作者策略为 Pro 功能') . '</th><td>';
		if ($is_pro) {
			$author_mode = (string)($site['author_mode'] ?? 'wp');
			if (!in_array($author_mode, ['wp', 'brand'], true)) {
				$author_mode = 'wp';
			}
			echo '<label><input type="radio" name="site_author_mode" value="wp"' . checked($author_mode, 'wp', false) . ' /> WordPress 作者</label><br />';
			echo '<label><input type="radio" name="site_author_mode" value="brand"' . checked($author_mode, 'brand', false) . ' /> 品牌 / 团队</label><br />';
			echo '<input class="regular-text" name="site_brand_author_name" value="' . esc_attr((string)($site['brand_author_name'] ?? '')) . '" placeholder="品牌作者名称（可选）" />';
			echo '<p class="description">用于结构化输出 author。你也可以在单篇文章中覆盖作者策略（编辑器侧）。</p>';
		} else {
			echo '<span style="color:#6b7280;">Free：固定使用 WordPress 作者。</span>';
		}
		echo '</td></tr>';
	}
}

