<?php

declare(strict_types=1);

namespace ContentReady\Admin\Tabs\Basic;

final class BehaviorRows
{
	public static function render(array $options, array $ui): void
	{
		echo '<tr><th scope="row"><label for="cr_ui_editor_entry_label">编辑器入口名称</label></th><td>';
		$editor_entry_label = trim(sanitize_text_field((string)($ui['editor_entry_label'] ?? '')));
		echo '<input class="regular-text" id="cr_ui_editor_entry_label" name="ui_editor_entry_label" value="' . esc_attr($editor_entry_label) . '" placeholder="内容就绪" />';
		echo '<p class="description">用于 Gutenberg 侧边栏与经典编辑器 Meta Box 的标题；建议短一点，避免编辑器侧边栏拥挤。</p>';
		echo '</td></tr>';

		echo '<tr><th scope="row">发布前检查</th><td>';
		$auto = !empty($options['checks']['auto_on_publish']);
		echo '<label><input type="checkbox" name="checks_auto_on_publish" value="1"' . checked($auto, true, false) . ' /> 发布/更新时自动运行“发布前检查”（不阻塞发布）</label>';
		echo '<p class="description">发布/更新后自动生成一份检查报告（不阻塞发布），用于更早发现“模块缺失/FAQ 条数不足/重复结构化输出”等问题。仅做检查，不会自动生成模块；如需发布后自动补齐模块，请到「自动化」开启（Pro）。你也可在编辑器内随时手动运行“发布前检查”查看详情。</p>';
		echo '</td></tr>';

		echo '<tr><th scope="row">匿名安装统计</th><td>';
		$telemetry_enabled = !empty($options['privacy']['telemetry_enabled']);
		echo '<label><input type="checkbox" name="privacy_telemetry_enabled" value="1"' . checked($telemetry_enabled, true, false) . ' /> 允许发送匿名安装/活跃统计（仅用于我们统计安装量与活跃量）</label>';
		echo '<p class="description">仅发送：随机安装 ID + 插件版本 + WP/PHP 版本 + 语言；不发送文章内容/站点域名/License Key。</p>';
		echo '</td></tr>';
	}
}

