<?php

declare(strict_types=1);

namespace ContentReady\Admin\Tabs;

use ContentReady\Admin\SettingsForm;

final class AdvancedTab
{
	public static function render(array $options): void
	{
		echo '<h2 style="margin-top:16px;">' . esc_html__('高级/维护', 'content-ready') . '</h2>';
		echo '<p class="description">包含卸载清理等维护项：不确定是否要开时，建议保持默认。</p>';
		SettingsForm::open('advanced');

		echo '<table class="form-table" role="presentation"><tbody>';

		echo '<tr><th scope="row">卸载清理</th><td>';
		$cleanup = !empty($options['uninstall']['cleanup']);
		echo '<label><input type="checkbox" name="uninstall_cleanup" value="1"' . checked($cleanup, true, false) . ' /> 卸载插件时清理数据（站点设置 + 已生成内容数据）</label>';
		echo '<p class="description">默认关闭；开启后卸载会删除站点配置与文章的插件数据（用于存储已生成模块）。</p>';
		echo '</td></tr>';

		echo '</tbody></table>';

		SettingsForm::close();
	}
}

