<?php

declare(strict_types=1);

namespace ContentReady\Admin\SettingsSections;

use ContentReady\Admin\SettingsSections\Modules\CardsSection;
use ContentReady\Admin\SettingsSections\Modules\DispatchModeSection;
use ContentReady\Licensing\Capabilities;
use ContentReady\Modules\Config as ModulesConfig;
use ContentReady\Modules\Dispatch as ModulesDispatch;
use ContentReady\Modules\Registry;

final class ModulesSection
{
	public static function render(array $options): void
	{
		$is_pro = Capabilities::is_pro($options);
		$modules_cfg = ModulesConfig::normalize_modules_config($options['modules'] ?? null);
		$order = ModulesConfig::default_order();

		$dispatch_mode = sanitize_key((string)($options['generation']['dispatch_mode'] ?? ModulesDispatch::MODE_OFF));
		if (!in_array($dispatch_mode, [ModulesDispatch::MODE_OFF, ModulesDispatch::MODE_ADAPTIVE, ModulesDispatch::MODE_LIGHTWEIGHT], true)) {
			$dispatch_mode = !empty($options['generation']['adaptive_enabled']) ? ModulesDispatch::MODE_ADAPTIVE : ModulesDispatch::MODE_OFF;
		}

		$readonly = $is_pro && $dispatch_mode === ModulesDispatch::MODE_LIGHTWEIGHT;
		$all_modules = Registry::all();
		$adaptive_defaults = array_flip(ModulesDispatch::adaptive_default_module_ids());

		echo '<h3 style="margin-top:20px;">模块配置</h3>';
		DispatchModeSection::render($is_pro, $dispatch_mode, $readonly, $all_modules);

		echo '<p class="description" style="margin-top:10px;">你可以配置：启用、显示名称、规则（如：FAQ 最少条数、摘要写入）以及提示词（可选，用于影响 AI 生成）。模块的顺序与展示位置由插件统一规划（不需要你手动调整）。</p>';
		CardsSection::render($options, $modules_cfg, $order, $all_modules, $adaptive_defaults, $is_pro, $readonly);
	}
}

