<?php

declare(strict_types=1);

namespace ContentReady\Admin\SettingsSections\Modules;

final class ModuleCardSummary
{
	public static function render(string $module_id, array $cfg, string $prompt, bool $is_content, bool $uses_ai): void
	{
		// 摘要信息（卡片内高密度展示）
		echo '<div class="cr-module-card__summary">';

		echo '<div class="cr-module-card__summary-item">';
		echo '<div class="cr-module-card__summary-k">AI</div>';
		if ($is_content && $uses_ai) {
			echo '<div class="cr-module-card__summary-v">启用后消耗 Token</div>';
		} elseif ($is_content && !$uses_ai) {
			echo '<div class="cr-module-card__summary-v">不走 AI（本地）</div>';
		} else {
			echo '<div class="cr-module-card__summary-v">—</div>';
		}
		echo '</div>';

		echo '<div class="cr-module-card__summary-item">';
		echo '<div class="cr-module-card__summary-k">规则</div>';
		if ($module_id === 'faq') {
			$min = (int)($cfg['min_rules']['faq_min_items'] ?? 3);
			echo '<div class="cr-module-card__summary-v">最少条数：' . esc_html((string)$min) . '</div>';
		} elseif ($module_id === 'toc') {
			$toc = is_array($cfg['toc'] ?? null) ? $cfg['toc'] : [];
			$open = !empty($toc['default_open']);
			$style = sanitize_key((string)($toc['list_style'] ?? 'unordered'));
			$style_label = $style === 'ordered' ? '有序' : '无序';
			$max = (int)($toc['max_level'] ?? 4);
			$max = max(2, min(5, $max));
			echo '<div class="cr-module-card__summary-v">默认' . ($open ? '展开' : '折叠') . '｜' . esc_html($style_label) . '｜到 H' . esc_html((string)$max) . '</div>';
		} elseif ($module_id === 'summary') {
			$mode = sanitize_key((string)($cfg['summary_excerpt'] ?? 'off'));
			if (!in_array($mode, ['off', 'force', 'compat'], true)) {
				$mode = 'off';
			}
			$label_map = [
				'off' => '不写入摘要',
				'compat' => '摘要为空时写入',
				'force' => '强制写入摘要',
			];
			echo '<div class="cr-module-card__summary-v">' . esc_html($label_map[$mode] ?? '—') . '</div>';
		} elseif ($module_id === 'table') {
			echo '<div class="cr-module-card__summary-v">优先匹配小节，兜底第 3 段</div>';
		} else {
			echo '<div class="cr-module-card__summary-v">—</div>';
		}
		echo '</div>';

		echo '<div class="cr-module-card__summary-item">';
		echo '<div class="cr-module-card__summary-k">提示词</div>';
		if ($is_content && $uses_ai) {
			echo '<div class="cr-module-card__summary-v">' . ($prompt !== '' ? '已自定义' : '默认') . '</div>';
		} else {
			echo '<div class="cr-module-card__summary-v">—</div>';
		}
		echo '</div>';

		echo '</div>'; // summary
	}
}

