<?php

declare(strict_types=1);

namespace ContentReady\Admin\SettingsSections\Modules;

final class ModuleCardOverlay
{
	public static function render(string $intro): void
	{
		$upgrade_url = trim((string)apply_filters('cr_pro_buy_url', 'https://xmtbx.com/content-ready'));
		if ($upgrade_url === '') {
			$upgrade_url = admin_url('admin.php?page=content-ready-settings&tab=license');
		}
		$upgrade_target = ' target="_blank" rel="noopener noreferrer"';
		echo '<div class="cr-module-card__overlay">';
		echo '<div class="cr-module-card__overlay-title">解锁 Pro 模块</div>';
		echo '<div class="cr-module-card__overlay-desc">' . esc_html($intro) . '</div>';
		echo '<a class="button button-primary" href="' . esc_url($upgrade_url) . '"' . $upgrade_target . '>升级到 Pro 版本</a>';
		echo '</div>';
	}
}

