<?php

declare(strict_types=1);

namespace ContentReady\Admin\SettingsSections\Modules;

use ContentReady\Admin\Ui\Badges;

final class ModuleCardHead
{
	public static function render(
		string $module_id,
		string $label,
		bool $is_pro_module,
		bool $uses_ai,
		bool $enabled,
		string $disabled,
		string $adaptive_default_attr
	): void {
		echo '<div class="cr-module-card__head">';
		echo '<div class="cr-module-card__title">';
		echo '<strong>' . esc_html($label !== '' ? $label : $module_id) . '</strong>';
		echo '<span class="cr-badge-wrap">';
		echo $is_pro_module ? Badges::pro('该模块为 Pro 模块') : '';
		echo $uses_ai ? Badges::ai('生成将消耗 AI Token') : '';
		echo '</span>';
		echo '</div>';

		echo '<div class="cr-module-card__actions">';
		echo '<label class="cr-module-card__toggle">';
		echo '<input type="checkbox" name="modules[' . esc_attr($module_id) . '][enabled]" value="1"' . checked($enabled, true, false) . $disabled . $adaptive_default_attr . ' />';
		echo '<span>启用</span>';
		echo '</label>';
		echo '</div>';
		echo '</div>'; // head
	}
}

