<?php

declare(strict_types=1);

namespace ContentReady\Admin\SettingsSections\Modules;

use ContentReady\Admin\Ui\Badges;

final class ModuleCardDetails
{
	public static function render(
		string $module_id,
		array $cfg,
		string $label,
		string $prompt,
		string $disabled,
		bool $is_content,
		bool $uses_ai,
		bool $is_pro,
		bool $locked
	): void {
		echo '<details class="cr-module-card__details">';
		echo '<summary>配置</summary>';

		echo '<div class="cr-module-card__details-body">';

		echo '<div class="cr-module-field">';
		echo '<label>显示名称</label>';
		echo '<input type="text" name="modules[' . esc_attr($module_id) . '][label]" value="' . esc_attr($label) . '"' . $disabled . ' />';
		echo '<p class="description">用于前端模块标题与编辑器面板显示。</p>';
		echo '</div>';

		if ($module_id === 'faq') {
			$min = (int)($cfg['min_rules']['faq_min_items'] ?? 3);
			echo '<div class="cr-module-field">';
			echo '<label>规则</label>';
			echo '<label>最少条数 <input type="number" min="1" max="20" name="modules[' . esc_attr($module_id) . '][min_rules][faq_min_items]" value="' . esc_attr((string)$min) . '"' . $disabled . ' /></label>';
			echo '<p class="description">条数不足会在检查中提示。</p>';
			echo '</div>';
		} elseif ($module_id === 'toc') {
			$toc = is_array($cfg['toc'] ?? null) ? $cfg['toc'] : [];
			$open = !empty($toc['default_open']);
			$style = sanitize_key((string)($toc['list_style'] ?? 'unordered'));
			if (!in_array($style, ['unordered', 'ordered'], true)) {
				$style = 'unordered';
			}
			$max = (int)($toc['max_level'] ?? 4);
			$max = max(2, min(5, $max));

			echo '<div class="cr-module-field">';
			echo '<label>规则</label>';

			echo '<div style="margin-bottom:6px;">';
			echo '<input type="hidden" name="modules[' . esc_attr($module_id) . '][toc][default_open]" value="0"' . $disabled . ' />';
			echo '<label><input type="checkbox" name="modules[' . esc_attr($module_id) . '][toc][default_open]" value="1"' . checked($open, true, false) . $disabled . ' /> 默认展开</label>';
			echo '</div>';

			echo '<div style="margin-bottom:6px;">';
			echo '<label>目录样式</label> ';
			echo '<select name="modules[' . esc_attr($module_id) . '][toc][list_style]"' . $disabled . '>';
			echo '<option value="unordered"' . selected($style, 'unordered', false) . '>无序（圆点）</option>';
			echo '<option value="ordered"' . selected($style, 'ordered', false) . '>有序（数字）</option>';
			echo '</select>';
			echo '</div>';

			echo '<div style="margin-bottom:6px;">';
			echo '<label>最大标题层级</label> ';
			echo '<select name="modules[' . esc_attr($module_id) . '][toc][max_level]"' . $disabled . '>';
			foreach ([4 => '到 H4（推荐）', 5 => '到 H5（更细）'] as $k => $t) {
				echo '<option value="' . esc_attr((string)$k) . '"' . selected($max, $k, false) . '>' . esc_html($t) . '</option>';
			}
			echo '</select>';
			echo '</div>';

			echo '<p class="description">提示：目录只会读取正文里的标题（H2-H5），不包含文章标题（H1）。</p>';
			echo '</div>';
		} elseif ($module_id === 'summary') {
			$mode = sanitize_key((string)($cfg['summary_excerpt'] ?? 'off'));
			if (!in_array($mode, ['off', 'force', 'compat'], true)) {
				$mode = 'off';
			}
			echo '<div class="cr-module-field">';
			echo '<label>规则</label>';
			echo '<label>写入文章摘要</label>';
			echo '<select name="modules[' . esc_attr($module_id) . '][summary_excerpt]"' . $disabled . '>';
			foreach (['off' => '不写入', 'compat' => '仅在文章摘要为空时写入（摘要不为空则不生成）', 'force' => '强制写入（覆盖已有摘要）'] as $k => $t) {
				echo '<option value="' . esc_attr($k) . '"' . selected($mode, $k, false) . '>' . esc_html($t) . '</option>';
			}
			echo '</select>';
			echo '<p class="description">用于让主题/SEO 插件更容易复用摘要内容。</p>';
			echo '</div>';
		} elseif ($module_id === 'table') {
			echo '<div class="cr-module-field">';
			echo '<label>插入策略</label>';
			echo '<div class="cr-module-card__muted">优先：匹配最相关的小节标题，插在该标题后的第一段落后；兜底：插在第 3 段落后（避免出现在文章开头）；最后兜底：追加到正文末尾。</div>';
			echo '<p class="description">提示：该策略用于让表格更自然地贴近对应的小节；如你的主题没有标准段落/标题结构，可能会退化为兜底策略。</p>';
			echo '</div>';
		}

		echo '<div class="cr-module-field">';
		echo '<label>提示词（可选） <span class="cr-badge-wrap">' . ($uses_ai ? Badges::ai('生成将消耗 AI Token') : '') . '</span></label>';
		if ($is_content && $uses_ai) {
			echo '<textarea rows="4" name="modules[' . esc_attr($module_id) . '][prompt]" placeholder="可选：为该模块追加额外要求（不会改变模块输出结构）"' . $disabled . '>' . esc_textarea($prompt) . '</textarea>';
			echo '<p class="description">提示：这是“补充要求”，会在生成时追加到你的提示后面。</p>';
		} elseif ($is_content && !$uses_ai) {
			echo '<input type="hidden" name="modules[' . esc_attr($module_id) . '][prompt]" value=""' . $disabled . ' />';
			echo '<div class="cr-module-card__muted">不走 AI</div>';
		} else {
			echo '<input type="hidden" name="modules[' . esc_attr($module_id) . '][prompt]" value=""' . $disabled . ' />';
			echo '<div class="cr-module-card__muted">—</div>';
		}
		echo '</div>';

		if (!$is_pro && $locked) {
			echo '<p class="description">Free：该模块为 Pro，已锁定不可启用。</p>';
		}

		echo '</div>'; // details-body
		echo '</details>';
	}
}

