<?php

declare(strict_types=1);

namespace ContentReady\Admin\SettingsSections\Modules;

use ContentReady\Licensing\Capabilities;
use ContentReady\Modules\Registry;

final class ModuleCard
{
	public static function render(
		string $module_id,
		array $cfg,
		array $options,
		array $all_modules,
		array $adaptive_defaults,
		bool $is_pro,
		bool $readonly
	): void {
		$is_content = Registry::is_content_module($module_id);
		$uses_ai = $is_content && !in_array($module_id, ['last_updated', 'toc'], true);

		$plan = Capabilities::module_plan($module_id);
		$is_pro_module = $is_content && $plan === Capabilities::PLAN_PRO;
		$locked = $is_content && !Capabilities::is_module_available($module_id, $options);
		$disabled = ((!$is_pro && $locked) || $readonly) ? ' disabled' : '';

		$enabled = !empty($cfg['enabled']);
		$label = (string)($cfg['label'] ?? $module_id);
		$prompt = (string)($cfg['prompt'] ?? '');
		$intro = (string)($all_modules[$module_id]['intro'] ?? '');
		if ($intro === '') {
			$intro = '用于增强页面的 GEO 内容结构与可读性。';
		}

		$card_class = 'cr-module-card' . ((!$is_pro && $locked) ? ' cr-module-card--locked' : '') . (!$enabled ? ' cr-module-card--disabled' : '');
		echo '<div class="' . esc_attr($card_class) . '" data-module-id="' . esc_attr($module_id) . '" data-module-label="' . esc_attr($label) . '" data-module-intro="' . esc_attr($intro) . '">';

		$adaptive_default_attr = ($is_content && isset($adaptive_defaults[$module_id])) ? ' data-cr-adaptive-default="1"' : '';
		ModuleCardHead::render($module_id, $label, $is_pro_module, $uses_ai, $enabled, $disabled, $adaptive_default_attr);

		echo '<div class="cr-module-card__body">';
		echo '<div class="cr-module-card__content">';

		echo '<div class="cr-module-card__intro">' . esc_html($intro) . '</div>';

		ModuleCardSummary::render($module_id, $cfg, $prompt, $is_content, $uses_ai);
		ModuleCardDetails::render($module_id, $cfg, $label, $prompt, $disabled, $is_content, $uses_ai, $is_pro, $locked);

		echo '</div>'; // content

		if (!$is_pro && $locked) {
			ModuleCardOverlay::render($intro);
		}

		echo '</div>'; // body
		echo '</div>'; // card
	}
}
