<?php

declare(strict_types=1);

namespace ContentReady\Admin\SettingsSections\Modules;

use ContentReady\Admin\Ui\Badges;
use ContentReady\Modules\Dispatch as ModulesDispatch;

final class DispatchModeSection
{
	public static function render(bool $is_pro, string $dispatch_mode, bool $readonly, array $all_modules): void
	{
		// 模块调度策略（Pro-only）
		echo '<table class="form-table" role="presentation"><tr>';
		echo '<th scope="row">模块调度策略 <span class="cr-badge-wrap">' . Badges::pro('模块调度策略为 Pro 功能') . Badges::ai('将影响 AI 调用与 Token 消耗') . '</span></th>';
		echo '<td>';

		$mode_labels = [
			ModulesDispatch::MODE_OFF => '关闭（手动选择模块）',
			ModulesDispatch::MODE_ADAPTIVE => '自适应（默认启用全部候选模块）',
			ModulesDispatch::MODE_LIGHTWEIGHT => '轻量精选（推荐组合）',
		];

		if ($is_pro) {
			echo '<select id="cr-generation-dispatch-mode" name="generation_dispatch_mode">';
			foreach ($mode_labels as $k => $label) {
				echo '<option value="' . esc_attr($k) . '"' . selected($dispatch_mode, $k, false) . '>' . esc_html($label) . '</option>';
			}
			echo '</select>';

			echo '<p class="description">推荐：优先使用「轻量精选」，通用 GEO 价值更高且 Token 成本更可控。</p>';
			echo '<p class="description">关闭：只生成你在下方启用的模块。自适应：会默认启用所有「GEO 内容模块」作为候选池，并根据正文信号自动跳过不适合的模块；如果你不需要某个模块，可在下方关闭它。轻量精选：使用推荐组合减少 AI 调用次数，优先保证通用收益与成本可控。</p>';

			$lw = ModulesDispatch::lightweight_recommended_module_ids();
			$lw_labels = [];
			foreach ($lw as $mid) {
				$mid = sanitize_key((string)$mid);
				$lw_labels[] = (string)($all_modules[$mid]['label'] ?? $mid);
			}
			echo '<p class="description">轻量精选推荐组合：' . esc_html(implode('、', $lw_labels)) . '。</p>';

			echo '<p id="cr-adaptive-enable-all-wrap" style="margin:8px 0 0;">';
			echo '<button type="button" class="button" id="cr-adaptive-enable-all">重新启用全部候选模块</button>';
			echo '<span class="description" style="margin-left:8px;">用于恢复“我全都要”的默认候选池（你仍可手动关闭不需要的模块）。</span>';
			echo '</p>';

			if ($readonly) {
				echo '<p class="description"><strong>提示：</strong>轻量精选模式下模块配置为只读；如需自定义模块开关与提示词，请先将调度策略切换为“关闭”或“自适应”。</p>';
			}
		} else {
			echo '<select disabled>';
			foreach ($mode_labels as $k => $label) {
				echo '<option value="' . esc_attr($k) . '"' . selected($dispatch_mode, $k, false) . '>' . esc_html($label) . '</option>';
			}
			echo '</select>';
			echo '<p class="description">Free：该功能为 Pro。你仍可在下方启用已解锁的模块。</p>';
		}

		echo '</td></tr></table>';
	}
}

